/*

METRIC CLOCK (C) 2005
http://www.madsense.net/
http://www.madsense.net/waygrander/

The Metric Clock Dashboard Widget was conceived by Erik Madsen,   
developed by Andrew Gray, and designed by the powerful force of
the pair's indomitable friendship. This clock is a tribute to
friends everywhere.

Much of the code was adapted from the World Clock widget, which is
Copyright 2005, Apple Computer, Inc. See the World Clock source
code for further copyright information.

*/

var timerInterval = null;

var clockHeight = 200;
var clockWidth = 200;

var clockFace = new Image(200,200);
clockFace.src = 'images/clock_face.pdf';

var decidayHand = new Image(20, 46);
decidayHand.src = 'images/deciday_hand.pdf';

var centidayHand = new Image(20, 59);
centidayHand.src = 'images/centiday_hand.pdf';

var millidayHand = new Image(5, 80);
millidayHand.src = 'images/milliday_hand.pdf';

var momentHand = new Image(3, 75);
momentHand.src = 'images/moment_hand.pdf';

var centerPlate = new Image(10, 10);
centerPlate.src  = 'images/center_plate.pdf';



function drawHands (decidayAngle, centidayAngle, millidayAngle, momentAngle) {

    // get a representative of the canvas (the 'context')
    var canvas = document.getElementById("clockCanvas");
    var context = canvas.getContext("2d");

    // clear what was on the canvas before
    context.clearRect(0, 0, clockWidth, clockHeight);

    context.save();
    context.translate(0, 0);
    context.drawImage(clockFace, 0, 150, 200, 200);
    context.restore();

    context.save();

    // move the origin to the centre
    context.translate(clockWidth/2, clockHeight/2);

    // similar procedure for the centiday hand
    context.save();
    context.rotate(centidayAngle);
    context.drawImage(centidayHand, -10, -12, 20, 59);
    context.restore();

    // draw the deciday hand
    context.save();
    context.rotate(decidayAngle);
    context.drawImage(decidayHand, -10, -10, 20, 46);
    context.restore();

    // and again for the milliday hand:
    context.save();
    context.rotate(millidayAngle);
    context.drawImage(millidayHand, -3, -2, 5, 80);
    context.restore();

    // and again for the moment hand:
    context.save();
    context.rotate(momentAngle);
    context.drawImage(momentHand, -1.5, -18, 3, 75);
    context.drawImage(centerPlate, -5, 3, 10, 10);
    context.restore();

    // restore to the untranslated context
    context.restore();

}




function startClock() {

  doneButton = document.getElementById('done');
  createGenericButton(doneButton, "Done", showfrontside);

  if (timerInterval == null) {
    timerInterval = setInterval(updateClock, 432);
  }
  updateClock();

}




function updateClock() {

  var mydate = new Date();

  var hrs = mydate.getHours();
  var min = mydate.getMinutes();
  var sec = mydate.getSeconds();
  var msc = mydate.getMilliseconds();

  var newtime = ((hrs * 3600) + (min * 60) + sec + (msc / 1000)) / 86400;

  newtime = Math.floor(newtime * 100000)/100000;

  drawHands( newtime * 2 * Math.PI,
           ((newtime * 10) % 1) * 2 * Math.PI,
           ((newtime * 100) % 1) * 2 * Math.PI,
           ((newtime * 1000) % 1) * 2 * Math.PI );

}




function showbackside(event) {

        var front = document.getElementById("front");
        var back = document.getElementById("behind");

	if (window.widget)
		widget.prepareForTransition("ToBack");

        onhide();

        front.style.display="none";
        back.style.display="block";

	if (window.widget)
		setTimeout('widget.performTransition();', 0);

}

function showfrontside(event) {

        var front = document.getElementById("front");
        var back = document.getElementById("behind");

	if (window.widget)
		widget.prepareForTransition("ToFront");

        front.style.display="block";
        back.style.display="none";

	setTimeout('flipitback();', 0);
        onshow();

}


function flipitback() {
	updateClock();
	if (window.widget)
		setTimeout("widget.performTransition();", 0);
}

/*
function enterflip(event) {
        document.getElementById('fliprollie').style.display = 'block';
}

function exitflip(event) {
        document.getElementById('fliprollie').style.display = 'none';
}
*/


var flipShown = false;

function mouseexit(event) {
        if (flipShown) {
                var flip = document.getElementById('flip');
                flip.style.display = 'none';
                flipShown = false;
        }
}

function mousemove(event) {
        if (!flipShown) {
                var flip = document.getElementById('flip');
                flip.style.display = 'block';
                flipShown = true;
        }
}




// SHOW AND HIDE

function onshow () {
  if (timerInterval == null) {
    timerInterval = setInterval(updateClock, 432);
  }
  updateClock();
}


function onhide () {
  if (timerInterval != null) {
    clearInterval(timerInterval);
    timerInterval = null;
  }
}


if (window.widget) {
        widget.onhide = onhide;
        widget.onshow = onshow;
}
